/******************************************************
 * ArchC arch-specific references header file.        *
 * This file is automatically generated by ArchC      *
 * WITHOUT WARRANTY OF ANY KIND, either express       *
 * or implied.                                        *
 * For more information on ArchC, please visit:       *
 * http://www.archc.org                               *
 *                                                    *
 * The ArchC Team                                     *
 * Computer Systems Laboratory (LSC)                  *
 * IC-UNICAMP                                         *
 * http://www.lsc.ic.unicamp.br                       *
 ******************************************************/

#ifndef _NIOS32_ARCH_REF_H_
#define _NIOS32_ARCH_REF_H_

#include "nios32_parms.H"
#include "ac_arch_ref.H"
#include "ac_memport.H"
#include "ac_regbank.H"
#include "ac_sync_reg.H"
#include "nios32_fmt_regs.H"

//! Forward class declarations, needed to compile.
class nios32_arch;

//! ArchC class for architecture-specific resources references.
class nios32_arch_ref: public ac_arch_ref<nios32_parms::ac_word, nios32_parms::ac_Hword>
{
 private:
  nios32_arch& p;

 protected:
  //! Program Counter register.
  ac_sync_reg<unsigned>& ac_pc;
  //! Storage devices.
  ac_memport<nios32_parms::ac_word, nios32_parms::ac_Hword>& DM;
  ac_regbank<128, nios32_parms::ac_word, nios32_parms::ac_Dword>& RB;
  nios32_fmt_F_IF_ID& IF_ID;
  nios32_fmt_F_ID_EX& ID_EX;
  nios32_fmt_F_EX_MEM& EX_MEM;
  nios32_fmt_F_MEM_WB& MEM_WB;
  nios32_fmt_F_STATUS& ctl0;
  nios32_fmt_F_ISTATUS& ctl1;
  nios32_fmt_F_WVALID& ctl2;
  ac_sync_reg<nios32_parms::ac_word>& ctl3;
  ac_sync_reg<nios32_parms::ac_word>& ctl4;
  ac_sync_reg<nios32_parms::ac_word>& ctl5;
  ac_sync_reg<nios32_parms::ac_word>& ctl6;
  ac_sync_reg<nios32_parms::ac_word>& ctl7;
  ac_sync_reg<nios32_parms::ac_word>& ctl8;
  ac_sync_reg<nios32_parms::ac_word>& ctl9;
  ac_sync_reg<nios32_parms::ac_word>& pc;
  nios32_fmt_F_K& k;
  //! Default constructor.
  nios32_arch_ref(nios32_arch& arch);
  //! Delegated read access to ac_pc.
  unsigned get_ac_pc();
};

#endif // _NIOS32_ARCH_REF_H_
